<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>
    <!-- Horizontal Alignment Review Report -->
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))" />
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <!-- Title displayed in browser Title Bar -->
                <title lang="en">Horizontal Alignment Review and Area Report</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <!-- Report Title -->
                                <h2 lang="en">Horizontal Alignment Review and Area Report</h2>
                                <p lang="en">
                                    Report Created:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                                    Time:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>
                            <!-- Project Data -->
                            <xsl:for-each select="GeometryProject">
                                <table class="margin" cellpadding="2" width="90%">
                                    <tbody>
                                        <tr>
                                            <th align="right" lang="en">Project:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@name"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Description:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@description"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">File Name:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@file"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Last Revised:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="concat(@lastRevisedBy, '  ', @lastRevisedDate)"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en" style="font-size: 80%">Input Grid Factor:&#xa0; </th>
                                            <td align="left" style="font-size: 80%"><xsl:value-of select="../@inputGridScaleFactor" /></td>
                                            <td align="right" lang="en" style="font-size: 80%">
                                                <strong>Note:&#xa0; </strong>All units in this report are in
                                                <xsl:if test="//@linearUnits = 'Imperial'">feet</xsl:if>
                                                <xsl:if test="//@linearUnits = 'Metric'">meters</xsl:if>
                                                unless specified otherwise.
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr/>
                                <!-- Horizontal Alignment Data -->
                                <table class="margin" width="90%">
                                    <colgroup span="5">
                                        <col width="18%"/>
                                        <col width="13%"/>
                                        <col width="25%"/>
                                        <col width="22%"/>
                                        <col width="22%"/>
                                    </colgroup>
                                    <xsl:for-each select="HorizontalAlignment">
                                        <tbody>
                                            <tr>
                                                <th align="right" colspan="2" lang="en"><br />Alignment Name:&#xa0;</th>
                                                <td align="left" colspan="3" valign="bottom"><xsl:value-of select="@name"/></td>
                                            </tr>
                                            <tr>
                                                <th align="right" colspan="2" lang="en">Alignment Description:&#xa0;</th>
                                                <td align="left" colspan="3"><xsl:value-of select="@description"/></td>
                                            </tr>
                                            <tr>
                                                <th align="right" colspan="2" lang="en">Alignment Style:&#xa0;</th>
                                                <td align="left" colspan="3"><xsl:value-of select="@style"/></td>
                                            </tr>
                                            <tr>
                                                <th colspan="2"/>
                                                <th align="right" class="underline" lang="en">Station</th>
                                                <th align="right" class="underline" lang="en">Northing</th>
                                                <th align="right" class="underline" lang="en">Easting</th>
                                            </tr>
                                            <xsl:apply-templates/>
                                        </tbody>
                                    </xsl:for-each>
                                </table>
<p/>
                                <table class="margin" cellpadding="2" width="50%">
							    				    <thead>
							    				        <tr>
							    				            <xsl:if test="//@linearUnits = 'Imperial'">
							    				                <th class="underline" lang="en">Lot</th>
							    				                <th class="underline" lang="en">Area (sq ft)</th>
							    				                <th class="underline" lang="en">Area (acres)</th>
							    				                <th class="underline" lang="en">Perimeter (ft)</th>
							    				            </xsl:if>
							    				            <xsl:if test="//@linearUnits =   'Metric'">
							    				                <th class="underline" lang="en">Lot</th>
							    				                <th class="underline" lang="en">Area (sq m)</th>
							    				                <th class="underline" lang="en">Area (hectares)</th>
							    				                <th class="underline" lang="en">Perimeter (m)</th>
							    				            </xsl:if>
							    				        </tr>
							    				    </thead>
							    				    <tbody>
							    				        <!--Horizontal Alignment Data-->
							    				        <xsl:for-each select="HorizontalAlignment[@area > 0]">
							    				            <tr>
							    				                <td class="sidepad" align="left"><xsl:value-of select="@name"/></td>
							    				                <td class="sidepad" align="right">
							    				                                                    <xsl:value-of select="cif:areaFormat(number(@area))"/>
							    				                </td>
							    				                <td class="sidepad" align="right">
							    				                    <xsl:if test="//@linearUnits = 'Imperial'">
							    				                        <xsl:value-of select="cif:acreFormat(number(@area) div 43560)"/>
							    				                    </xsl:if>
							    				                    <xsl:if test="//@linearUnits = 'Metric'">
							    				                        <xsl:value-of select="cif:acreFormat(number(@area) div 10000)"/>
							    				                    </xsl:if>
							    				                </td>
							    				                <td class="sidepad" align="right">
							    				                    <xsl:value-of select="cif:distanceFormat(number(@perimeter))"/>
							    				                </td>
							    				            </tr>
							    				        </xsl:for-each>
							    				    </tbody>
                                </table>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>
    <!-- Horizontal Linear Data -->
    <xsl:template match="HorizontalLine">
        <tr>
            <td align="left" colspan="5" lang="en"><br/>Element: Linear</td>
        </tr>
        <tr>
            <td align="right"><xsl:value-of select="Start/@type"/></td>
            <td align="right">( <xsl:value-of select="Start/@name"/> )</td>
            <td align="right">
                <xsl:value-of select="cif:stationFormat(number(Start/station/@externalStation), string(Start/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(Start/@northing))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(Start/@easting))"/>
            </td>
        </tr>
        <xsl:if test="StationEquation">
            <xsl:for-each select="StationEquation">
                <tr>
                    <td align="right" colspan="2" lang="en">EQNBK</td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(@backStation), string(@backEquation))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@northing))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@easting))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">EQNAHD</td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(@aheadStation), string(@aheadEquation))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@northing))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@easting))"/>
                    </td>
                </tr>
            </xsl:for-each>
        </xsl:if>
        <tr>
            <td align="right"><xsl:value-of select="End/@type"/></td>
            <td align="right">( <xsl:value-of select="End/@name"/> )</td>
            <td align="right">
                <xsl:value-of select="cif:stationFormat(number(End/station/@externalStation), string(End/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(End/@northing))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(End/@easting))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Tangential Direction:</td>
            <td align="right">
                <xsl:value-of select="cif:directionFormat(number(@direction))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Tangential Length:</td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@length))"/>
            </td>
        </tr>
    </xsl:template>
    <!-- Horizontal Circular Data -->
    <xsl:template match="HorizontalCircle">
        <tr>
            <td align="left" colspan="5" lang="en"><br/>Element: Circular</td>
        </tr>
        <tr>
            <td align="right"><xsl:value-of select="Start/@type"/></td>
            <td align="right">( <xsl:value-of select="Start/@name"/> )</td>
            <td align="right">
                <xsl:value-of select="cif:stationFormat(number(Start/station/@externalStation), string(Start/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(Start/@northing))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(Start/@easting))"/>
            </td>
        </tr>
        <xsl:if test="PI">
            <tr>
                <td align="right"><xsl:value-of select="PI/@type"/></td>
                <td align="right">( <xsl:value-of select="PI/@name"/> )</td>
                <td align="right">
                    <xsl:value-of select="cif:stationFormat(number(PI/station/@externalStation), string(PI/station/@externalStationName))"/>
                </td>
                <td align="right">
                    <xsl:value-of select="cif:ordinateFormat(number(PI/@northing))"/>
                </td>
                <td align="right">
                    <xsl:value-of select="cif:ordinateFormat(number(PI/@easting))"/>
                </td>
            </tr>
        </xsl:if>
        <tr>
            <td align="right"><xsl:value-of select="Center/@type"/></td>
            <td align="right">( <xsl:value-of select="Center/@name"/> )</td>
            <td />
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(Center/@northing))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(Center/@easting))"/>
            </td>
        </tr>
        <xsl:if test="StationEquation">
            <xsl:for-each select="StationEquation">
                <tr>
                    <td align="right" colspan="2" lang="en">EQNBK</td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(@backStation), string(@backEquation))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@northing))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@easting))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">EQNAHD</td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(@aheadStation), string(@aheadEquation))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@northing))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@easting))"/>
                    </td>
                </tr>
            </xsl:for-each>
        </xsl:if>
        <tr>
            <td align="right"><xsl:value-of select="End/@type"/></td>
            <td align="right">( <xsl:value-of select="End/@name"/> )</td>
            <td align="right">
                <xsl:value-of select="cif:stationFormat(number(End/station/@externalStation), string(End/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(End/@northing))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(End/@easting))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Radius:</td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@radius))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Delta:</td>
            <td align="right">
                <xsl:value-of select="cif:angularFormat(number(@delta))"/>
            </td>
            <td align="left" lang="en">
                <xsl:if test="@rotationDirection='cw'">Right</xsl:if>
                <xsl:if test="@rotationDirection = 'ccw'">Left</xsl:if>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">
                <xsl:if test="../../@curvatureDefinition = 'arc'">
                     Degree of Curvature (Arc):
                </xsl:if>
                <xsl:if test="../../@curvatureDefinition = 'chord'">
                    Degree of Curvature (Chord):
                </xsl:if>
            </td>
            <td align="right">
                <xsl:value-of select="cif:angularFormat(number(@degreeOfCurve))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Length:</td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@length))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Tangent:</td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@tangentLength))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Chord:</td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@chord))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Middle Ordinate:</td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@middleOrdinate))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">External:</td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@externalDistance))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Tangent Direction:</td>
            <td align="right">
                <xsl:value-of select="cif:directionFormat(number(@tangentialDirectionStart))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Radial Direction:</td>
            <td align="right">
                <xsl:value-of select="cif:directionFormat(number(@radialDirectionStart))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Chord Direction:</td>
            <td align="right">
                <xsl:value-of select="cif:directionFormat(number(@chordDirection))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Radial Direction:</td>
            <td align="right">
                <xsl:value-of select="cif:directionFormat(number(@radialDirectionEnd))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Tangent Direction:</td>
            <td align="right">
                <xsl:value-of select="cif:directionFormat(number(@tangentialDirectionEnd))"/>
            </td>
        </tr>
    </xsl:template>
    <!-- Horizontal Spiral Data -->
    <xsl:template match="HorizontalSpiral">
        <tr>
            <td align="left" colspan="5" lang="en"><br/>Element: 
                <xsl:choose>
                    <xsl:when test="@compound = 'false'">
                        <xsl:value-of select="@type"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text> Compound </xsl:text>
                        <xsl:value-of select="@type"/>
                    </xsl:otherwise>
                </xsl:choose>
            </td>
        </tr>
        <tr>
            <td align="right"><xsl:value-of select="Start/@type"/></td>
            <td align="right">( <xsl:value-of select="Start/@name"/> )</td>
            <td align="right">
                <xsl:value-of select="cif:stationFormat(number(Start/station/@externalStation), string(Start/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(Start/@northing))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(Start/@easting))"/>
            </td>
        </tr>
        <tr>
            <td align="right"><xsl:value-of select="PI/@type"/></td>
            <td align="right">( <xsl:value-of select="PI/@name"/> )</td>
            <td align="right">
                <xsl:value-of select="cif:stationFormat( number(PI/station/@externalStation), string(PI/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(PI/@northing))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(PI/@easting))"/>
            </td>
        </tr>
        <xsl:if test="StationEquation">
            <xsl:for-each select="StationEquation">
                <tr>
                    <td align="right" colspan="2" lang="en">EQNBK</td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(@backStation), string(@backEquation))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@northing))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@easting))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">EQNAHD</td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(@aheadStation), string(@aheadEquation))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@northing))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@easting))"/>
                    </td>
                </tr>
            </xsl:for-each>
        </xsl:if>
        <tr>
            <td align="right"><xsl:value-of select="End/@type"/></td>
            <td align="right">( <xsl:value-of select="End/@name"/> )</td>
            <td align="right">
                <xsl:value-of select="cif:stationFormat(number(End/station/@externalStation), string(End/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(End/@northing))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(End/@easting))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Entrance Radius:</td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@startRadius))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Exit Radius:</td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@endRadius))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Length:</td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@length))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Angle:</td>
            <td align="right">
                <xsl:value-of select="cif:angularFormat(number(@thetaAngle))"/>
            </td>
            <td lang="en">
                <xsl:if test="@rotationDirection='cw'">Right</xsl:if>
                <xsl:if test="@rotationDirection = 'ccw'">Left</xsl:if>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Constant:</td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@aConstant))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Long Tangent:</td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@longTangent))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Short Tangent:</td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@shortTangent))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Long Chord:</td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@longChord))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Xs:</td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@xs))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Ys:</td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@ys))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">P:</td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@p))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">K:</td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@ks))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Tangent Direction:</td>
            <td align="right">
                <xsl:value-of select="cif:directionFormat(number(@tangentialDirectionStart))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Radial Direction:</td>
            <td align="right">
                <xsl:value-of select="cif:directionFormat(number(@radialDirectionStart))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Chord Direction:</td>
            <td align="right">
                <xsl:value-of select="cif:directionFormat(number(@chordDirection))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Radial Direction:</td>
            <td align="right">
                <xsl:value-of select="cif:directionFormat(number(@radialDirectionEnd))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Tangent Direction:</td>
            <td align="right">
                <xsl:value-of select="cif:directionFormat(number(@tangentialDirectionEnd))"/>
            </td>
        </tr>
    </xsl:template>
    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Notes</h4>
            <p class="normal1" lang="en">
                You must include at least one horizontal alignment in the <em>Include</em> field on the 
                <em>Tools &gt; XML Reports &gt; Geometry</em> command to get results from this report.
            </p>
            <p class="small" lang="en">
                <em>&#xa9; 2006 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>
